<?php
/* --------------------------------------------------------------
   TrackingCodeServiceProvider.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode;

use Doctrine\DBAL\Connection;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeService;
use Gambio\Admin\TrackingCode\Repository\TrackingCodeMapper;
use Gambio\Admin\TrackingCode\Repository\TrackingCodeReader;
use Gambio\Admin\TrackingCode\Repository\TrackingCodeRepository;
use Gambio\Admin\TrackingCode\Repository\TrackingCodeWriter;
use Gambio\Admin\TrackingCode\TrackingCodeService as TrackingCodeServiceImpl;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class TrackingCodeServiceProvider
 *
 * @package Gambio\Admin\TrackingCode
 * @codeCoverageIgnore
 */
class TrackingCodeServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            TrackingCodeService::class,
            TrackingCodeFactory::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(TrackingCodeFactory::class);
        
        $this->application->share(TrackingCodeMapper::class)->addArgument(TrackingCodeFactory::class);
        $this->application->share(TrackingCodeReader::class)->addArgument(Connection::class);
        $this->application->share(TrackingCodeWriter::class)->addArgument(Connection::class);
        
        $this->application->share(TrackingCodeRepository::class)
            ->addArgument(TrackingCodeMapper::class)
            ->addArgument(TrackingCodeReader::class)
            ->addArgument(TrackingCodeWriter::class)
            ->addArgument(EventDispatcherInterface::class);
        
        $this->application->share(TrackingCodeService::class, TrackingCodeServiceImpl::class)
            ->addArgument(TrackingCodeRepository::class);
    }
}